function callback(name, data) {
  if (!data) data = '';
  window.location.href = 'skp:' + name + '@' + data;
}

function init() {
  var w = $( window ).width();
  var h = $( window ).height();
  var data = '['+w+','+h+']';
  callback('init', data);
}

function input_changed(id, val) {
  var data = '['+':'+ id+','+val+']';
  callback('input_changed', data);
}

$(document).ready( function() {

  // Initialize
  window.setTimeout(init(), 0);

  // Process checkbox and radio input triggers.
  $( 'input[type=checkbox], input[type=radio]' ).change( function() {
    input_changed(this.name, this.checked);
  });

  // Process button clicks
  $( 'input[type=submit]' ).click( function() {
    callback('button_clicked', this.name);
  });

  // Detect slider movements.
  $( '#sel1' ).change( function(event, ui) {
    callback('slider_slide', this.value);
  });

  $( '#sel1' ).on( 'slidestart', function( event ) {
    callback('slider_slide_start', this.value)
  });

  $( '#sel1' ).on( 'slidestop', function( event ) {
    callback('slider_slide_stop', this.value)
  });

  $( window ).focus(function() {
    callback('window_focus');
  });

  $( window ).blur(function() {
    callback('window_blur');
  });

});
